/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.earth;

import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.ui.bonsai.servlet.util.TaskUrl;
import com.ibm.hwmca.ui.bonsai.util.SortedList;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

public class TaskNode
implements Serializable {
    private static MyComparator taskNodeComparator = new MyComparator();
    private String id;
    private UIInfo uIInfo;
    private boolean isTask;
    private TaskUrl url;
    private List children;

    public TaskNode(String id, UIInfo uIInfo, boolean isTask, TaskUrl url) {
        this.id = id;
        this.uIInfo = uIInfo;
        this.isTask = isTask;
        this.url = url;
        this.children = new SortedList(TaskNode.getTaskNodeComparator());
    }

    public TaskNode(String id, UIInfo uIInfo, boolean isTask) {
        this(id, uIInfo, isTask, null);
    }

    public String getId() {
        return this.id;
    }

    public void addChild(TaskNode childNode) throws IllegalStateException {
        if (this.isTask) {
            throw new IllegalStateException("This node is a task, and can not have any children!");
        }
        this.children.add(childNode);
    }

    public void addChildren(List childNodes) throws IllegalStateException {
        if (this.isTask) {
            throw new IllegalStateException("This node is a task, and can not have any children!");
        }
        this.children.addAll(childNodes);
    }

    public List getChildren() {
        return this.children;
    }

    public String getName() {
        return this.uIInfo.getName();
    }

    public String getName(Locale locale) {
        return this.uIInfo.getName(locale);
    }

    public String getCaption() {
        return this.uIInfo.getCaption();
    }

    public String getCaption(Locale locale) {
        return this.uIInfo.getCaption(locale);
    }

    public String getImageUrl() {
        return this.uIInfo.getImageURL();
    }

    public String getImageName() {
        return this.uIInfo.getImageName();
    }

    public void setUrl(TaskUrl url) {
        this.url = url;
    }

    public TaskUrl getUrl() {
        return this.isTask() ? this.url : null;
    }

    public String getUrlString() {
        return this.isTask() ? this.url.toString() : null;
    }

    public boolean isTask() {
        return this.isTask;
    }

    public TaskNode getNoChildrenClone() {
        return new TaskNode(this.id, this.uIInfo, this.isTask, this.isTask ? (TaskUrl)this.url.clone() : null);
    }

    public TaskNode getNoChildrenNoUrlClone() {
        return new TaskNode(this.id, this.uIInfo, this.isTask);
    }

    public boolean equals(Object obj) {
        try {
            if (obj == null) {
                return false;
            }
            return this.id.equals(((TaskNode)obj).getId());
        }
        catch (ClassCastException ccEx) {
            return false;
        }
    }

    public int hashCode() {
        return Integer.decode("0x" + this.id);
    }

    public String toString() {
        return this.uIInfo.getName();
    }

    public static Comparator getTaskNodeComparator() {
        return taskNodeComparator;
    }

    private static class MyComparator
    implements Comparator,
    Serializable {
        public int compare(Object obj1, Object obj2) {
            TaskNode node1 = (TaskNode)obj1;
            TaskNode node2 = (TaskNode)obj2;
            if (!node1.isTask() && node2.isTask()) {
                return -1;
            }
            if (node1.isTask() && !node2.isTask()) {
                return 1;
            }
            int result = node1.getName().compareTo(node2.getName());
            if (result == 0) {
                result = node1.getId().compareTo(node2.getId());
            }
            return result;
        }

        public boolean equals(Object obj) {
            return obj instanceof MyComparator;
        }
    }
}

